-- Common things you'll find on every Eval screen.
-- With luck, they should position themselves.

-- tap note types
-- (iterating through the enum isn't a good idea as everything's backwards,
-- plus you have to start at 4)
local TNSNames = {
	THEME:GetString("TapNoteScore","W1"),
	THEME:GetString("TapNoteScore","W2"),
	THEME:GetString("TapNoteScore","W3"),
	THEME:GetString("TapNoteScore","W4"),
	THEME:GetString("TapNoteScore","W5"),
	THEME:GetString("TapNoteScore","Miss"),
	"Holds",
	"Max Combo"
};

-- JudgeLabels()
-- Print all the boring labels.
local function JudgeLabels()
	local l = Def.ActorFrame{};
	
	for i=1,#TNSNames do
		l[#l+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
			InitCommand=cmd(shadowlength,1;zoom,0.833);
			BeginCommand=function(self)
				self:y((i-1)*24);
				self:settext(TNSNames[i]);
				if i < 6 then -- W1-W5
					self:diffuse( JudgeColor('TapNoteScore_W'..i) );
				elseif i == 6 then -- Miss
					self:diffuse( JudgeColor('TapNoteScore_Miss') );
				elseif i == 7 then -- holds
					self:diffuse( JudgeColor('TapNoteScore_W1') );
				elseif i == 8 then -- max combo
					self:diffuse( PlayerColor(PLAYER_1) );
				end;
			end;
		};
	end;
	
	return l;
end;

local TNSTypes = {
	'TapNoteScore_W1',
	'TapNoteScore_W2',
	'TapNoteScore_W3',
	'TapNoteScore_W4',
	'TapNoteScore_W5',
	'TapNoteScore_Miss'
};

-- MaxCombo(pn)
-- Gets pn's max combo. Used by JudgeNumbers.
local function MaxCombo(pn)
	local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	
	local function MaxComboGlow()
		local bMaxComboObtained = stats:FullCombo();
		if not bMaxComboObtained then return;
		else return cmd(glowshift);
		end;
	end;
	
	return LoadFont("_frutiger lt std 55 roman 24px")..{
		Text=stats:MaxCombo();
		InitCommand=cmd(shadowlength,1;zoom,0.833);
		BeginCommand=function(self)
			if pn == PLAYER_1 then
				self:horizalign(right);
			else self:horizalign(left);
			end;
			
			self:diffuse(PlayerColor(pn));
			if MaxComboGlow() then
				self:glowshift();
				self:effectcolor1(PlayerColor(pn));
				self:effectcolor2(color("1,1,1,1"));
			else
				self:stopeffect();
			end;
		end;
	};
end;

-- JudgeNumbers(pn)
-- Print all the numbers.
local function JudgeNumbers(pn)
	local n = Def.ActorFrame{};
	local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	
	-- do the normals first
	for i=1,#TNSTypes do
		n[#n+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
			InitCommand=cmd(shadowlength,1;zoom,0.833);
			BeginCommand=function(self)
				self:y((i-1)*24);
				self:settext(stats:GetTapNoteScores(TNSTypes[i]));
				self:diffuse(PlayerColor(pn));
				if pn == PLAYER_1 then
					self:horizalign(right);
				else self:horizalign(left);
				end;
			end;
		};
	end;
	-- now for the holds and drops
	local OK = stats:GetHoldNoteScores('HoldNoteScore_Held');
	local NG = stats:GetHoldNoteScores('HoldNoteScore_LetGo');
	local lenOK = string.len(OK);
	local lenNG = string.len(NG);
	local attribOK = {
		Length = lenOK;
		Diffuse = JudgeColor('TapNoteScore_W1');
	};
	local attribSlash = {
		Length = 1;
		Diffuse = color("1,1,1,1");
	};
	local attribNG = {
		Length = lenNG;
		Diffuse = JudgeColor('TapNoteScore_Miss');
	};
	
	n[#n+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
		Text=OK.."/"..NG;
		InitCommand=cmd(shadowlength,1;zoom,0.833);
		BeginCommand=function(self)
			self:y(24*(#TNSNames-2));
			self:AddAttribute(0,attribOK);
			self:AddAttribute(lenOK,attribSlash);
			self:AddAttribute(lenOK+1,attribNG);
			if pn == PLAYER_1 then
				self:horizalign(right);
			else self:horizalign(left);
			end;
		end;
	};
	
	n[#n+1] = MaxCombo(pn)..{
		InitCommand=cmd(y,24*(#TNSNames-1));
	};
	
	return n;
end;

-- Percentage(pn)
-- Gets the percentage for the specified player.
-- [v1.3] percent now glows on AAA or AAAA.
local function Percentage(pn)
	local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	local percent = stats:GetPercentDancePoints();
	
	local grade = stats:GetGrade();
	
	return LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="Score"..pn;
		Text=FormatPercentScore(percent);
		InitCommand=cmd(shadowlength,1);
		BeginCommand=function(self)
			local text = self:GetText();
			if text == "100.00%" then self:SetText("100%");
			end;
			
			local diff;
			
			if GAMESTATE:IsCourseMode() then
				diff = GAMESTATE:GetCurrentTrail(pn):GetDifficulty();
			else
				diff = GAMESTATE:GetCurrentSteps(pn):GetDifficulty();
			end;
			self:diffuse( DifficultyColor(diff) );
			
			if grade == 'Grade_Tier01' or grade == 'Grade_Tier02' then
				self:glowshift();
			else
				self:stopeffect();
			end;
		end;
	};
end;

-- RecordTexts(pn)
-- Gets record texts for specified player.
local function RecordTexts(pn)
	local r = Def.ActorFrame{};
	local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	
	local bMachineRecord = ( stats:GetMachineHighScoreIndex() == 0 );
	local bPersonalRecord = ( stats:GetPersonalHighScoreIndex() == 0 );
	
	r[#r+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
		Text="New Machine Record!";
		InitCommand=cmd(zoom,0.5;shadowlength,1;diffuse,PlayerColor(pn);glowshift;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.25"));
		BeginCommand=function(self)
			if bMachineRecord then self:visible(true);
			else self:visible(false);
			end;
		end;
	};
	
	r[#r+1] = LoadFont("_frutiger lt std 55 roman 24px")..{
		Text="New Personal Record!";
		InitCommand=cmd(zoom,0.5;shadowlength,1;y,16;diffuse,PlayerColor(pn);glowshift;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.25"));
		BeginCommand=function(self)
			if bPersonalRecord then self:visible(true);
			else self:visible(false);
			end;
		end;
	};
	
	return r;
end;

-- Awards(pn)
-- Get awards for specified player.

-- [v1.4] This feature has been classified as low priority and will show up
-- in the SVN version of dubaiOne, if time permits.
local function Awards(pn)
	local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	local a = Def.ActorFrame{};
	
	-- GetPerDifficultyAward
	
	return a;
end;

-- StagesSurvived(pn)
-- Gets the stages survived for the current player.
local function StagesSurvived(pn)
	return LoadFont("_frutiger lt std 55 roman 24px")..{
		InitCommand=cmd(shadowlength,1;zoom,0.8);
		BeginCommand=function(self)
			if not GAMESTATE:IsCourseMode() then return; end;
			
			local proxy;
			local text = "";
			if pn == PLAYER_1 then
				proxy = SCREENMAN:GetTopScreen():GetChild('SurvivedNumberP1');
				self:horizalign(left);
			else
				proxy = SCREENMAN:GetTopScreen():GetChild('SurvivedNumberP2');
				self:horizalign(right);
			end;
			if proxy then
				text = proxy:GetText();
			end;
			self:settext( text .. " stages" );
		end;
	};
end;

local common = Def.ActorFrame{
	-- background
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_eval", 244,282 )..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+55);
	};
	-- separator
	Def.Quad{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-40;zoomto,250,4;diffuse,color("#000000");fadeleft,0.25;faderight,0.25);
	};
	-- labels
	JudgeLabels()..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-24);
	};
	Def.Quad{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP+36;zoomto,SCREEN_CENTER_X,20;diffuse,color("#000000");fadeleft,0.5;faderight,0.5);
	};
	-- song/course title
	LoadFont("_frutiger lt std 55 roman 24px")..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP+36;shadowlength,1;zoom,0.55);
		BeginCommand=function(self)
			local song = GAMESTATE:GetCurrentSong();
			local course = GAMESTATE:GetCurrentCourse();
			local s = "";
			if GAMESTATE:IsCourseMode() then
				s = course:GetDisplayFullTitle();
			else
				s = song:GetDisplayFullTitle() .. " / " .. song:GetDisplayArtist();
			end;
			self:settext(s);
		end;
	};
	-- song options
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Text=GAMESTATE:GetSongOptionsString();
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-90;zoom,0.6;shadowlength,1);
	};
	
	-- Player 1!
	Def.ActorFrame{
		Name="P1Results";
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(PLAYER_1) then self:visible(true); return;
			end;
			self:visible(false);
		end;
		
		-- percentage
		Percentage(PLAYER_1)..{
			InitCommand=cmd(x,SCREEN_CENTER_X-80;y,SCREEN_CENTER_Y-72);
			BeginCommand=function(self)
				if GAMESTATE:IsCourseMode() then
					self:addy(-8);
				end;
			end;
		};
		
		-- stages survived (course mode)
		StagesSurvived(PLAYER_1)..{
			InitCommand=cmd(x,SCREEN_CENTER_X-108;y,SCREEN_CENTER_Y-56);
		};
		
		-- numb3rs, the hit show on CBS
		JudgeNumbers(PLAYER_1)..{
			InitCommand=cmd(x,SCREEN_CENTER_X-64;y,SCREEN_CENTER_Y-24);
		};
		
		-- Record Texts
		RecordTexts(PLAYER_1)..{
			InitCommand=cmd(x,SCREEN_CENTER_X-64;y,SCREEN_CENTER_Y+168);
		};
		
		-- Option Icons
		LoadActor("OptionIcons",PLAYER_1)..{
			InitCommand=cmd(x,SCREEN_LEFT+80;y,SCREEN_HEIGHT*0.25);
		};
	};
	
	-- Player 2!
	Def.ActorFrame{
		Name="P2Results";
		BeginCommand=function(self)
			if GAMESTATE:IsSideJoined(PLAYER_2) then self:visible(true); return;
			end;
			self:visible(false);
		end;
		
		-- percentage
		Percentage(PLAYER_2)..{
			InitCommand=cmd(x,SCREEN_CENTER_X+80;y,SCREEN_CENTER_Y-72);
			BeginCommand=function(self)
				if GAMESTATE:IsCourseMode() then
					self:addy(-8);
				end;
			end;
		};
		
		-- stages survived (course mode)
		StagesSurvived(PLAYER_2)..{
			InitCommand=cmd(x,SCREEN_CENTER_X+108;y,SCREEN_CENTER_Y-56);
		};
		
		-- numb3rs, the hit show on CBS
		JudgeNumbers(PLAYER_2)..{
			InitCommand=cmd(x,SCREEN_CENTER_X+64;y,SCREEN_CENTER_Y-24);
		};
		
		-- Record Texts
		RecordTexts(PLAYER_2)..{
			InitCommand=cmd(x,SCREEN_CENTER_X+64;y,SCREEN_CENTER_Y+168);
		};
		
		-- Option Icons
		LoadActor("OptionIcons",PLAYER_2)..{
			InitCommand=cmd(x,SCREEN_RIGHT-80;y,SCREEN_HEIGHT*0.25);
		};
	};
};

return common;